import React, { useEffect, useRef, useState } from 'react';
import {
    Image,
    ScrollView,
    Text,
    TouchableOpacity,
    View,
    Pressable,
    StyleSheet,
} from 'react-native';
import { useDispatch, useSelector } from 'react-redux';
import { isArray } from 'underscore';
import useAuth from '../../../../hooks/useAuth';
import { getMyRefunds } from '../../../../redux/slices/user/myRefund/getMyRefunds';
import { postNewRefund } from '../../../../redux/slices/user/myRefund/postUpdateRefund';
import { getMoreOrders, getMyOrders } from '../../../../redux/slices/user/orderHistory/getOrderHistory';
import RequestRefundSkeleton from '../../../../src/skeletons/screens/profile/refund/RequestRefundSkeleton';
import BackNavigation from '../../../Utilities/CustomHeader/BackNavigation';
import CustomSpinner from '../../../Utilities/CustomSpinner/CustomSpinner';
import dpr from '../../../Utilities/CustomStyleAttribute/dpr';
import { ProfileStyles } from '../../ProfileStyle';
import { MyRefundStyle } from '../MyRefundStyle';
import { refundStyle } from './RefundRequestStyle';
import { handleProduct } from './rrfunctions/handleProduct';
import { query } from '../../../../redux/slices/util/apiRequest';
import PlusIcon from '../../../../assets/svgs/cart/plus.svg';
import UploadIcon from '../../../../assets/svgs/reviews/upload-photo-icon.svg';
import useUploadMultipleFile from '../../../../hooks/useUploadMultipleFile';
import useCustomToast from '../../../../hooks/useCustomToast';
import { BASE_API_URL_STG } from '@env';
import SelectInput from '../../../../src/components/CustomInput/SelectInput/SelectInput';
import DownArrowFill from '../../../../assets/svgs/downArrowFill.svg';
import SelectItemBottomSheet from '../../../../src/components/SelectItemBottomSheet/SelectItemBottomSheet';
import useLangTranslation from '../../../../hooks/useLangTranslation';
import CustomSmallLoader from '../../../../src/components/CustomLoader/CustomSmallLoader';
import CustomSVG from '../../../../src/components/CustomSVG/CustomSVG';

const RefundRequest = (props) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const showToast = useCustomToast();
    const { loading } = useSelector((state) => state.postUpdateRefund);
    const initialState = {
        invoice_id: '',
        order_detail_id: '',
        quantity: '',
        reason: '',
        image: [],
        is_default: 0,
    };
    const errorText = {
        invoice_id: false,
        order_detail_id: false,
        quantity: false,
        reason: false,
    };
    const [refundRequest, setRefundRequest] = useState(initialState);
    const [error, setError] = useState(errorText);
    const { myOrders, isRefresh, nextPageUrl, loadMore, loading: orderLoading } = useSelector(
        (state) => state.getMyOrdersSlice
    );
    const { order_detail_id, invoice_id, quantity, reason, image } =
        refundRequest;
    const { access_token } = useAuth();
    const [images, setImages] = useState([]);

    const [orders, setOrders] = useState([]);
    const [products, setProducts] = useState([]);
    const [numberOfQuantity, setNumberOfQuantity] = useState([]);
    const [reasons, setReasons] = useState([]);
    const [loadReason, setLodReason] = useState(true);

    const orderNumberRef = useRef(null);
    const [selectOrder, setSelectOrder] = useState(null);
    const productRef = useRef(null);
    const [selectProduct, setSelectProduct] = useState(null);
    const selectQuantityRef = useRef(null);
    const [selectQuantity, setSelectQuantity] = useState(null);
    const selectReasonRef = useRef(null);
    const [selectReason, setSelectReason] = useState(null);

    const uploadImages = useUploadMultipleFile();
    const pickImage = async () => {
        try {
            const results = await uploadImages();
            const margeImage = [...images, ...results].filter(
                (item, index, self) =>
                    index === self.findIndex((img) => img.uri === item.uri || img.name === item.name)
            );
            
            setImages(margeImage);
            setRefundRequest({
                ...refundRequest,
                image: margeImage,
            });
        } catch (error) {}
    };

    const urlPost = `${BASE_API_URL_STG}/user/refunds`;
    const UrlGet = `${BASE_API_URL_STG}/user/refunds`;
    useEffect(() => {
        (async () => {
            let isMounted = true;
            if (isMounted && myOrders?.length === 0) {
                const URL = `${BASE_API_URL_STG}/user/orders?filter_status=completed`;
                try {
                    await dispatch(getMyOrders({ access_token, URL }));
                } catch (error) {}
            }
            return () => {
                isMounted = false;
            };
        })()
    }, []);

    const handleLoadMoreOrders = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreOrders({ access_token, URL: nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };

    useEffect(() => {
        if (myOrders?.length > 0) {
            let allOrders = [];
            for (let orders of myOrders) {
                if (orders.status == 'Completed') {
                    let x = orders?.line_items?.filter((item) => {
                        let totalRefunds = 0;
                        item.refunds.forEach((refund) => {
                            totalRefunds += parseInt(refund.quantity);
                        });
                        if (totalRefunds != item.quantity) return item;
                    });
                    if (x.length > 0) {
                        allOrders.push({ ...orders, line_items: x });
                    }
                }
            }
            setOrders(allOrders);
        }
    }, [myOrders]);

    useEffect(() => {
        (async () => {
            let isMounted = true;
            if (isMounted) {
                const URL = `${BASE_API_URL_STG}/user/refunds/reasons`;
                try {
                    setLodReason(true);
                    const reasons = await query(URL, 'GET', access_token);
                    const { status: { code } = {}, records } = reasons?.response;
                    if (code === 200) {
                        let allReason = [];
                        for (let reason of records?.data) {
                            allReason.push(reason);
                        }
                        setReasons(allReason);
                        setLodReason(false);
                    }
                    setLodReason(false);
                } catch (error) {
                    setLodReason(false);
                }
            }
            return () => {
                isMounted = false;
            };
        })()
    }, []);

    const handleRefundRequestInfo = (name, text) => {
        if (name === 'invoice_id') {
            setRefundRequest({
                ...refundRequest,
                [name]: text,
                order_detail_id: '',
                quantity: '',
            });
        } else if (name === 'order_detail_id') {
            setRefundRequest({ ...refundRequest, [name]: text, quantity: '' });
        } else if (name === 'quantity') {
            setRefundRequest({ ...refundRequest, [name]: text });
        } else if (name === 'reason') {
            setRefundRequest({ ...refundRequest, [name]: text });
        } else if (name === 'image') {
            setRefundRequest({
                ...refundRequest,
                [image]: text,
            });
        } else {
            setRefundRequest({
                ...refundRequest,
                [name]: text,
            });
        }
    };

    const handleProductQuantity = (id) => {
        if (products.length > 0) {
            const is_Exits_Product = products.find(
                (product) => product.product_id === id
            );
            if (is_Exits_Product?.refunds.length > 0) {
                let totalQuantity = 0;

                for (let refund in is_Exits_Product?.refunds) {
                    const previousQuantity = is_Exits_Product?.refunds[refund];
                    totalQuantity += parseInt(previousQuantity.quantity);
                }

                let number = [];
                for (
                    let quantity = 1;
                    quantity <=
                    parseInt(is_Exits_Product?.quantity) - totalQuantity;
                    quantity++
                ) {
                    number.push({ name: quantity });
                }
                return number;
            } else {
                if (is_Exits_Product) {
                    const number = [];
                    for (
                        let quantity = 1;
                        quantity <= is_Exits_Product?.quantity;
                        quantity++
                    ) {
                        number.push({ name: quantity });
                    }
                    return number;
                }
            }
        }
    };
    const handleValidationError = () => {
        const order = order_detail_id === '' ? true : false;
        const invoice = invoice_id === '' ? true : false;
        const quantity_item = quantity === '' ? true : false;
        const reason_id = reason === '' ? true : false;
        setError({
            ...error,
            order_detail_id: order,
            invoice_id: invoice,
            quantity: quantity_item,
            reason: reason_id,
        });
    };
    const handleRefundRequest = async () => {
        refundRequest.is_default = refundRequest?.is_default ? 0 : 1;

        const { order_detail_id, quantity, reason, image } = refundRequest;
        if (
            order_detail_id &&
            invoice_id &&
            quantity &&
            reason
        ) {
            const orderURL = `${BASE_API_URL_STG}/user/orders?filter_status=completed`;
            let formData = new FormData();
            formData.append('order_detail_id', order_detail_id);
            formData.append('quantity_sent', quantity);
            formData.append('refund_reason_id', reason);
            for (let item of image) {
                formData.append('image[]', item);
            }
            let data = {
                access_token,
                urlPost,
                method: 'POST',
                formData,
            };
            try {
                let newAdd = await dispatch(postNewRefund(data));
                let { code, message: statusMsg } = newAdd?.payload?.status;
                let { message } = newAdd?.payload?.records;
                if (code === 200) {
                    showToast({
                        text1: trans(message),
                        type: 'common',
                        bottomOffset: 0,
                        position: 'bottom',
                        props: { variant: 'success' },
                    });
                    setRefundRequest(initialState);
                    setError(errorText);
                    dispatch(getMyRefunds({ access_token, URL: UrlGet }));
                    await dispatch(
                        getMyOrders({ access_token, URL: orderURL })
                    );
                    props.navigation.goBack();
                } else {
                    showToast({
                        text1: trans(message || statusMsg),
                        type: 'common',
                        bottomOffset: 0,
                        position: 'bottom',
                        props: { variant: 'error' },
                    });
                }
            } catch (error) {}
        } else {
            handleValidationError();
        }
    };
    const handleOrderNumber = (selectedItem) => {
        setSelectOrder(selectedItem?.order_key);
        if (selectedItem?.order_key) {
            const filterableProduct = handleProduct(selectedItem?.id, myOrders);
            setSelectProduct(null);
            setProducts(filterableProduct);
            setSelectQuantity(null);
            setNumberOfQuantity([]);
            handleRefundRequestInfo('invoice_id', selectedItem.id);
            setError({
                ...error,
                invoice_id: false,
            });
        }
    };
    const handleProductSelect = (selectedItem) => {
        setSelectProduct(selectedItem?.name);
        const qty = handleProductQuantity(selectedItem.product_id);
        setSelectQuantity(null);
        setNumberOfQuantity(qty);
        handleRefundRequestInfo('order_detail_id', selectedItem.id);
        setError({
            ...error,
            order_detail_id: false,
        });
    };
    const handleQuantitySelect = (selectedItem) => {
        setSelectQuantity(selectedItem?.name);
        handleRefundRequestInfo('quantity', selectedItem?.name);
        setError({
            ...error,
            quantity: false,
        });
    };
    const handleReasonSelect = (selectedItem) => {
        setSelectReason(selectedItem?.name);
        handleRefundRequestInfo('reason', selectedItem.id);
        setError({
            ...error,
            reason: false,
        });
    };

    const styles = Styles(error, products, numberOfQuantity);

    return (
        <View style={refundStyle.spreadFlex}>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans('refund')}
                capitalize={true}
            />
            <View style={ProfileStyles.hrLine} />
            {orderLoading ? (
                <RequestRefundSkeleton />
            ) : myOrders?.length === 0 && !orderLoading && isArray(myOrders) ? (
                <View style={MyRefundStyle.noRefund}>
                    <Text style={MyRefundStyle.noRefundText}>
                        {trans('There Have No Products For Refund')}
                    </Text>
                </View>
            ) : (
                <View style={refundStyle.spreadFlex}>
                    <ScrollView
                        style={refundStyle.mb85}
                        showsVerticalScrollIndicator={false}
                    >
                        <View style={refundStyle.container}>
                            <View style={refundStyle.inputCont}>
                                <Text style={refundStyle.label}>
                                    {trans('Select Order Number')}
                                </Text>
                                <SelectInput
                                    style={[refundStyle.dropdown1BtnStyle, styles.orderNumberSelect]}
                                    placeholder={trans('Select Option')}
                                    onPress={() => {
                                        orderNumberRef.current?.snapToIndex(0);
                                    }}
                                    title={selectOrder}
                                    icon={<CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />}
                                />
                            </View>
                            <View style={refundStyle.inputCont}>
                                <Text style={refundStyle.label}>
                                    {trans('Select Product')}
                                </Text>
                                <SelectInput
                                    style={[refundStyle.dropdown1BtnStyle, styles.productSelect]}
                                    disabled={
                                        products.length === 0 ? true : false
                                    }
                                    placeholder={trans('Select Product')}
                                    onPress={() => {
                                        productRef.current?.snapToIndex(0);
                                    }}
                                    title={selectProduct}
                                    icon={<CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />}
                                />
                            </View>
                            <View style={refundStyle.inputCont}>
                                <Text style={refundStyle.label}>
                                    {trans('Select Quantity')}
                                </Text>
                                <SelectInput
                                    style={[refundStyle.dropdown1BtnStyle, styles.quantitySelect]}
                                    disabled={
                                        numberOfQuantity?.length === 0
                                            ? true
                                            : false
                                    }
                                    placeholder={trans('Select Quantity')}
                                    onPress={() => {
                                        selectQuantityRef.current?.snapToIndex(
                                            0
                                        );
                                    }}
                                    title={selectQuantity}
                                    icon={<CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />}
                                />
                            </View>
                            <View style={refundStyle.inputCont}>
                                <Text style={refundStyle.label}>
                                    {trans('Select Your Reason')}
                                </Text>
                                <SelectInput
                                    style={[refundStyle.dropdown1BtnStyle, styles.reasonSelect]}
                                    placeholder={trans('Select Reason')}
                                    onPress={() => {
                                        selectReasonRef.current?.snapToIndex(0);
                                    }}
                                    title={trans(selectReason)}
                                    icon={
                                        loadReason ? (
                                            <CustomSmallLoader />
                                        ) : (
                                            <CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />
                                        )
                                    }
                                />
                            </View>
                            <View style={refundStyle.inputCont}>
                                <Text style={refundStyle.label}>
                                    {trans('Images of the Product')}
                                </Text>
                                {!images.length ? (
                                    <View>
                                        <TouchableOpacity
                                            style={refundStyle.uploadPhotos}
                                            onPress={pickImage}
                                        >
                                            <View>
                                                <CustomSVG svgIcon={UploadIcon}
                                                    width={dpr(35)}
                                                    height={dpr(31)}
                                                />
                                            </View>
                                            <View>
                                                <Text
                                                    style={
                                                        refundStyle.uploadText
                                                    }
                                                >
                                                    {trans('Click here to upload photos')}
                                                </Text>
                                            </View>
                                        </TouchableOpacity>
                                    </View>
                                ) : (
                                    <>
                                        <View style={refundStyle.imgContainer}>
                                            {images.map((img, i) => {
                                                return (
                                                    <View key={i}>
                                                        {img?.uri && <Image
                                                            style={
                                                                refundStyle.imgStyle
                                                            }
                                                            source={{
                                                                uri: img?.uri,
                                                            }}
                                                        />}
                                                    </View>
                                                );
                                            })}
                                            <TouchableOpacity
                                                onPress={pickImage}
                                            >
                                                <View
                                                    style={
                                                        refundStyle.addPhotosCon
                                                    }
                                                >
                                                    <CustomSVG svgIcon={PlusIcon}
                                                        height={dpr(16)}
                                                        width={dpr(16)}
                                                        fill={'#c4c4c4'}
                                                    />
                                                </View>
                                            </TouchableOpacity>
                                        </View>
                                    </>
                                )}
                            </View>
                        </View>
                    </ScrollView>
                    <View>
                        <Pressable
                            style={MyRefundStyle.requestRefund}
                            disabled={loading ? true : false}
                            onPress={handleRefundRequest}
                        >
                            {loading ? (
                                <CustomSpinner
                                    filePath={require('../../../../assets/lottie/loader2.json')}
                                    size={{
                                        width: dpr(55),
                                        height: dpr(55),
                                    }}
                                />
                            ) : (
                                <Text style={MyRefundStyle.requestText}>
                                    {trans('Send Request')}
                                </Text>
                            )}
                        </Pressable>
                    </View>
                </View>
            )}
            {orders?.length > 0 && (
                <SelectItemBottomSheet
                    snapPoint={[300]}
                    selectRef={orderNumberRef}
                    data={orders}
                    onPress={handleOrderNumber}
                    handleLoadMoreOrders={handleLoadMoreOrders}
                    loadMore={loadMore}
                    loading={orderLoading}
                    isLazyLoad={true}
                />
            )}
            {products?.length > 0 && (
                <SelectItemBottomSheet
                    snapPoint={[300]}
                    selectRef={productRef}
                    name={'products'}
                    data={products}
                    onPress={handleProductSelect}
                />
            )}
            {numberOfQuantity?.length > 0 && (
                <SelectItemBottomSheet
                    snapPoint={[300]}
                    selectRef={selectQuantityRef}
                    data={numberOfQuantity}
                    onPress={handleQuantitySelect}
                />
            )}
            {reasons?.length > 0 && (
                <SelectItemBottomSheet
                    snapPoint={[300]}
                    selectRef={selectReasonRef}
                    data={reasons}
                    onPress={handleReasonSelect}
                />
            )}
        </View>
    );
};

export default RefundRequest;

const Styles = (error, products, numberOfQuantity) => StyleSheet.create({
    orderNumberSelect: {
        borderColor: error.invoice_id ? '#E43147' : '#DFDFDF',
    },
    productSelect: {
        borderColor: error.order_detail_id ? '#E43147' : '#DFDFDF',
        backgroundColor: products.length === 0 ? '#DFDFDF' : '#ffffff',
    },
    quantitySelect: {
        borderColor: error.quantity ? '#E43147' : '#DFDFDF',
        backgroundColor: numberOfQuantity?.length === 0 ? '#DFDFDF' : '#ffffff',
    },
    reasonSelect: {
        borderColor: error.reason ? '#E43147' : '#DFDFDF'
    }
});
